# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Stock Performance
import numpy as np; np.random.seed(0)
x_stock_a = np.random.normal(5, 1.5, 10)  # Expected Return (Stock A)
y_stock_a = np.random.normal(20, 5, 10)  # Volatility (Stock A)

# Bonds Performance
x_bonds = np.random.normal(3, 1, 10)  # Expected Return (Bonds)
y_bonds = np.random.normal(10, 3, 10)  # Volatility (Bonds)

# Real Estate Performance
x_real_estate = np.random.normal(4, 1.2, 10)  # Expected Return (Real Estate)
y_real_estate = np.random.normal(15, 4, 10)  # Volatility (Real Estate)

# Axis labels and limits
xlabel = "Expected Return (%)"
ylabel = "Volatility (Risk) (%)"
ax1xlim = [0, 10]
ax1ylim = [0, 30]
ax2xlim = [2, 6]
ax2ylim = [8, 22]
diffline1 = [[0, 0], [0, 10], [0, 30]]
diffline2 = [[0, 0], [2, 6], [8, 22]]
title1 = "Overall Asset Performance"
title2 = "Zoom-in View"
label = ["Stock Performance", "Bonds Performance", "Real Estate Performance"]
plot_up1 = [2, 10]
plot_down1 = [2, 22]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(x_stock_a, y_stock_a, marker="o", color="blue", label="Stock Performance")
ax1.scatter(x_bonds, y_bonds, marker="s", color="red", label="Bonds Performance")
ax1.scatter(x_real_estate, y_real_estate, marker="^", color="green", label="Real Estate Performance")

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="lightblue", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Scatter plots for zoom-in view
ax2.scatter(x_stock_a, y_stock_a, marker="o", color="red", label=label[0])
ax2.scatter(x_bonds, y_bonds, marker="s", color="blue", label=label[1])
ax2.scatter(x_real_estate, y_real_estate, marker="^", color="green", label=label[2])

# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=2, x2=ax2xlim[1], color="lightgreen", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('PIP_13.pdf', bbox_inches='tight')