
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np; np.random.seed(0)
# Data
x = ["Electric Vehicles", "Hybrid Vehicles", "Diesel Vehicles", "Gasoline Vehicles"]
y1 = [15, 25, 40, 50]  # Year 1 adoption (in %)
y2 = [22, 30, 38, 48]  # Year 2 adoption (in %)
y3 = [28, 35, 36, 45]  # Year 3 adoption (in %)
y4 = [35, 40, 33, 43]  # Year 4 adoption (in %)
labels = ["Year 1", "Year 2", "Year 3", "Year 4"]
insertax1 = [0.6, 0.55, 0.1, 0.3]
insertylim1 = [30, 45]
insertxlim1 = [1.5, 2.5]
insertax2 = [0.85, 0.30, 0.1, 0.3]
insertylim2 = [30, 50]
insertxlim2 = [2.5, 3.5]
xlabel = "Vehicle Type"
ylabel = "Adoption Percentage"
title = "Vehicle Adoption Over Time"
insetaxes = [0.6, 0.15, 0.1, 0.3]
arrowend1 = [0.6, 0.35]
arrowend2 = [0.9, 0.35]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

ax.plot(x, y1, "r-*", label=labels[0])
ax.plot(x, y2, "b-v", label=labels[1])
ax.plot(x, y3, "g--o", label=labels[2])
ax.plot(x, y4, "y-.s", label=labels[3])

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, "r-*")
ax_inset1.plot(x, y2, "b-v")
ax_inset1.plot(x, y3, "g--o")
ax_inset1.plot(x, y4, "y-.s")
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Create the second inset with the zoomed-in view
ax_inset2 = fig.add_axes(insertax2)
ax_inset2.plot(x, y1, "r-*")
ax_inset2.plot(x, y2, "b-v")
ax_inset2.plot(x, y3, "g--o")
ax_inset2.plot(x, y4, "y-.s")
ax_inset2.spines["bottom"].set_color("black")
ax_inset2.spines["left"].set_color("black")
ax_inset2.spines["top"].set_color("black")
ax_inset2.spines["right"].set_color("black")
ax_inset2.set_ylim(insertylim2)
ax_inset2.set_xlim(insertxlim2)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="lower right")
ax.grid(True)
ax.annotate(
    "",
    xy=(x[2], y3[2]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)
ax.annotate(
    "",
    xy=(x[3], y3[3]),
    xytext=arrowend2,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('PIP_15.pdf', bbox_inches='tight')
