# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for vehicle brands
import numpy as np; np.random.seed(42)
vehicle_brands = {
    "EcoRides": np.random.normal(loc=(50, 100), scale=20, size=(50, 2)),
    "RideMax": np.random.normal(loc=(70, 80), scale=20, size=(30, 2)),
    "FleetXpress": np.random.normal(loc=(90, 150), scale=20, size=(40, 2)),
    "AutoPhantom": np.random.normal(loc=(120, 60), scale=20, size=(60, 2)),
    "QuickMove": np.random.normal(loc=(80, 50), scale=20, size=(70, 2)),
    "UrbanGo": np.random.normal(loc=(40, 120), scale=20, size=(45, 2)),
}

# Colors for vehicle brands
colors = {
    "EcoRides": "red",
    "RideMax": "blue",
    "FleetXpress": "green",
    "AutoPhantom": "purple",
    "QuickMove": "orange",
    "UrbanGo": "yellow",
}
plot_title = "Vehicle Mileage vs. Fuel Efficiency"
xlabel = "Mileage (Thousand Miles)"
ylabel = "Fuel Efficiency (Miles per Gallon)"

# Inset plot configuration
insetaxes = [0.2, 0.6, 0.3, 0.3]
insetxlim = [50, 100]  # Focus on EcoRides and RideMax
insetylim = [80, 120]
insetxticks = [50.0, 70.0, 100.0]
insetyticks = [80.0, 100.0, 120.0]

# Arrow and annotation configuration
arrowstart = (50, 110)  # Arrow start for EcoRides
arrowend = (0.38, 0.7)  # Relative inset arrow end
annotaterecx = [50, 100]  # Annotation range for X
annotaterecy = [80, 120]  # Annotation range for Y
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
fig, ax = plt.subplots(figsize=(10, 8))
for team, data in vehicle_brands.items():
    ax.scatter(data[:, 0], data[:, 1], c=colors[team], label=team, alpha=0.6, edgecolors='w', s=100)

# Enclosing rectangle for annotation
rect = plt.Rectangle((annotaterecx[0], annotaterecy[0]), annotaterecx[1] - annotaterecx[0], annotaterecy[1] - annotaterecy[0], 
                     linewidth=1, edgecolor='black', facecolor='none')
ax.add_patch(rect)

# Create the inset with zoomed-in view
ax_inset = fig.add_axes(insetaxes)
for team, data in vehicle_brands.items():
    ax_inset.scatter(data[:, 0], data[:, 1], c=colors[team], alpha=0.6, edgecolors='w', s=40)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

ax.annotate(
    "",
    xy=arrowstart,
    xytext=arrowend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=1),
)

# Adding titles and labels
ax.set_title(plot_title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig('PIP_19.pdf', bbox_inches='tight')