# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Data for the plot with different financial metrics
months = np.array([1, 2, 3, 4, 5, 6])
revenue = np.array([100, 150, 200, 250, 300, 350]) + np.random.uniform(-10, 10, 6)
profit = np.array([20, 30, 50, 80, 100, 120]) + np.random.uniform(-5, 5, 6)
expenses = np.array([80, 120, 150, 200, 250, 300]) + np.random.uniform(-10, 10, 6)
investments = np.array([10, 20, 30, 40, 50, 60]) + np.random.uniform(-5, 5, 6)
benchmark_financial = np.linspace(200, 200, len(months))  # Benchmark line

# Extracted variables for labels
fill_label_revenue = "Revenue"
fill_label_profit = "Profit"
fill_label_expenses = "Expenses"
fill_label_investments = "Investments"
plot_label_benchmark = "Benchmark"
title_text = "Financial Metrics Over 6 Months"
xlabel_text = "Months"
ylabel_text = "Amounts ($)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (0, 400)
xticks_values = months
yticks_values = [0, 50, 100, 150, 200, 250, 300, 350, 400]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.08)
legend_ncol = 5

# Create the plot with a financial style
plt.figure(figsize=(10, 6))
plt.fill_between(months, revenue, color="forestgreen", alpha=0.3, label=fill_label_revenue)
plt.fill_between(months, profit, color="royalblue", alpha=0.3, label=fill_label_profit)
plt.fill_between(months, expenses, color="gold", alpha=0.3, label=fill_label_expenses)
plt.fill_between(months, investments, color="darkorange", alpha=0.3, label=fill_label_investments)
plt.plot(months, benchmark_financial, color="black", linestyle="--", linewidth=2, label=plot_label_benchmark)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which='both', linestyle='--', linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_11.pdf", bbox_inches="tight")