# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Data for the plot representing patient recovery rates in different hospitals
years = np.array([2017, 2018, 2019, 2020, 2021, 2022])
hospital_a = np.array([75, 78, 80, 82, 85, 88]) + np.random.normal(0, 2, 6)  # Adding noise
hospital_b = np.array([65, 68, 70, 73, 76, 78]) + np.random.normal(0, 2, 6)
hospital_c = np.array([60, 63, 65, 68, 70, 72]) + np.random.normal(0, 2, 6)
hospital_d = np.array([55, 58, 60, 62, 65, 67]) + np.random.normal(0, 2, 6)
benchmark = np.linspace(70, 70, len(years))  # Benchmark line

# Extracted variables
fill_label_hospital_a = "Hospital A"
fill_label_hospital_b = "Hospital B"
fill_label_hospital_c = "Hospital C"
fill_label_hospital_d = "Hospital D"
plot_label_benchmark = "Benchmark"
title_text = "Patient Recovery Rates Over Time by Hospital"
xlabel_text = "Year"
ylabel_text = "Recovery Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (50, 90)
xticks_values = years
yticks_values = np.arange(50, 91, 10)
legend_title = "Hospitals"
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1

# Create the plot with a health-appropriate color scheme
plt.figure(figsize=(10, 6))
plt.fill_between(years, hospital_a, color="purple", alpha=0.3, label=fill_label_hospital_a)
plt.fill_between(years, hospital_b, color="cyan", alpha=0.3, label=fill_label_hospital_b)
plt.fill_between(years, hospital_c, color="magenta", alpha=0.3, label=fill_label_hospital_c)
plt.fill_between(years, hospital_d, color="yellow", alpha=0.3, label=fill_label_hospital_d)
plt.plot(
    years, benchmark, color="black", linestyle="--", linewidth=2, label=plot_label_benchmark
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_12.pdf", bbox_inches="tight")