# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)  # Ensuring reproducibility

# Data
n_aug = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
scientific_discoveries = np.array([8, 10, 15, 9, 11, 14, 17, 20, 18, 22, 19, 24])
patents_filed = np.array([5, 7, 11, 6, 9, 12, 15, 18, 16, 20, 17, 21])

# Calculate cumulative values for stacked area chart
cumulative_discoveries = scientific_discoveries
cumulative_patents = cumulative_discoveries + patents_filed

# Positions for the bars on the x-axis
ind = np.arange(len(n_aug))

# Variables for plot configuration
discoveries_label = "Scientific Discoveries"
patents_label = "Patents Filed"
xlabel_text = "Month"
ylabel_text = "Count"
title_text = "Monthly Scientific Activity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 11)
ylim_values = (0, 50)
yticks_values = list(range(0, 60, 10))
legend_location = "upper left"
legend_fontsize = 10
legend_frameon = True
legend_shadow = False
legend_facecolor = "#f9f9f9"
legend_ncol = 2
legend_bbox_to_anchor = (0.1, 1.0)
# Plot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjusted for better aspect ratio
ax.fill_between(
    n_aug, 0, cumulative_discoveries, label=discoveries_label, color="#34bfa3", alpha=0.7
)
ax.fill_between(
    n_aug,
    cumulative_discoveries,
    cumulative_patents,
    label=patents_label,
    color="#fa9e57",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=18, y=1.02)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_15.pdf", bbox_inches="tight")
