
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Sample data
# Updated data
time_step = np.linspace(0, 4, 40)
rsa_gt = np.log(time_step + 1) * 10  # Example transformation
rsa_drs = np.log(time_step + 1) * 8  # Example transformation
rsa_pr = np.log(time_step + 1) * 5  # Example transformation
cr_gt = 0.5 + 0.5 * np.cos(time_step)  # Example transformation
cr_drs = 0.5 + 0.4 * np.cos(0.7 * time_step)  # Example transformation
cr_pr = 0.5 + 0.3 * np.cos(0.5 * time_step)  # Example transformation

# Extracted variables
rsa_gt_label = "Temperature"
rsa_drs_label = "Pressure"
rsa_pr_label = "Humidity"
cr_gt_label = "Temperature"
cr_drs_label = "Pressure"
cr_pr_label = "Humidity"
rsa_ylim = [0, 17]
rsa_xlim = [0, 4]
rsa_yticks = [0, 3, 6, 9, 12, 15]
rsa_xticks = [0, 1, 2, 3, 4]
rsa_ylabel = "RSA (Log Scale)"
cr_ylim = [0, 1]
cr_xlim = [0, 4]
cr_yticks = [0, 0.2, 0.4, 0.6, 0.8, 1]
cr_xticks = [0, 1, 2, 3, 4]
cr_xlabel = "Time Step (hours)"
cr_ylabel = "CR (Cosine)"
legend_labels = ["Temperature", "Pressure", "Humidity"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Plot RSA
ax1.plot(time_step, rsa_gt, "o-", color="#377e22", label=rsa_gt_label)
ax1.fill_between(time_step, rsa_gt, color="#ebf2e8")
ax1.plot(time_step, rsa_drs, "s-", color="#020ddc", label=rsa_drs_label)
ax1.fill_between(time_step, rsa_drs, color="#d3dbe4")
ax1.plot(time_step, rsa_pr, "^-", color="#bd2b25", label=rsa_pr_label)
ax1.fill_between(time_step, rsa_pr, color="#cdc6cf")
ax1.set_ylim(rsa_ylim)
ax1.set_xlim(rsa_xlim)
ax1.set_yticks(rsa_yticks)
ax1.set_xticks(rsa_xticks)
ax1.set_ylabel(rsa_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot CR
ax2.plot(time_step, cr_gt, "o-", color="#377e22", label=cr_gt_label)
ax2.fill_between(time_step, cr_gt, color="#ebf2e8")
ax2.plot(time_step, cr_drs, "s-", color="#020ddc", label=cr_drs_label)
ax2.fill_between(time_step, cr_drs, color="#d3dbe4")
ax2.plot(time_step, cr_pr, "^-", color="#bd2b25", label=cr_pr_label)
ax2.fill_between(time_step, cr_pr, color="#cdc6cf")
ax2.set_ylim(cr_ylim)
ax2.set_xlim(cr_xlim)
ax2.set_yticks(cr_yticks)
ax2.set_xticks(cr_xticks)
ax2.set_xlabel(cr_xlabel)
ax2.set_ylabel(cr_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
green_line = mlines.Line2D([], [], color="green", marker="o", markersize=6, label=legend_labels[0])
blue_line = mlines.Line2D([], [], color="blue", marker="s", markersize=6, label=legend_labels[1])
red_line = mlines.Line2D([], [], color="red", marker="^", markersize=6, label=legend_labels[2])
plt.legend(handles=[green_line, blue_line, red_line], loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=6, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('area_2.pdf', bbox_inches='tight')
