# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
years = [2005, 2006, 2007, 2008, 2009]
research_fund = [20, 25, 30, 35, 40]  # Monthly Research Funding in USD million
salaries = [15, 17, 19, 22, 25]  # Monthly Salaries in USD million
equipment_costs = [5, 8, 10, 12, 15]  # Monthly Equipment Costs in USD million

# Labels for legend
label_research_fund = "Research Funding"
label_salaries = "Salaries"
label_equipment_costs = "Equipment Costs"

# Title and labels
plot_title = "Research Department Monthly Expenditures"
xlabel_text = "Years"
ylabel_text = "Million USD"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits
xlim_values = (2005, 2009)
ylim_values = (0, 45)

# Axis labels
xlabel_values = ["2005", "2006", "2007", "2008", "2009"]
ylabel_values = [0, 10, 20, 30, 40]

# Axis ticks
xticks_values = years
yticks_values = [0, 10, 20, 30, 40]

# Plotting the data
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better
plt.plot(
    years,
    research_fund,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#3498db",
    markeredgecolor="#2980b9",
    markersize=10,
    color="#2980b9",
    label=label_research_fund,
)
plt.plot(
    years,
    salaries,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#e74c3c",
    markeredgecolor="#c0392b",
    markersize=10,
    color="#c0392b",
    label=label_salaries,
)
plt.plot(
    years,
    equipment_costs,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ecc71",
    markeredgecolor="#27ae60",
    markersize=10,
    color="#27ae60",
    label=label_equipment_costs,
)

# Filling the area under the curves
plt.fill_between(years, research_fund, salaries, color="#3498db", alpha=0.4)
plt.fill_between(years, salaries, equipment_costs, color="#e74c3c", alpha=0.4)
plt.fill_between(years, equipment_costs, 0, color="#2ecc71", alpha=0.4)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=16, pad=20)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_6.pdf", bbox_inches="tight")