# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting (Amount of Daily Caloric Intake by Different Age Groups)
years = [2015, 2016, 2017, 2018, 2019]
child_calories = [1800, 1850, 1900, 1950, 2000]
teen_calories = [2400, 2450, 2500, 2550, 2600]
adult_calories = [2200, 2250, 2300, 2350, 2400]
senior_calories = [2000, 2050, 2100, 2150, 2200]

# Labels for legend
label_child = "Children (4-8 years)"
label_teen = "Teenagers (14-18 years)"
label_adult = "Adults (19-50 years)"
label_senior = "Seniors (51+ years)"

# Horizontal line value
axhline_value = 2400

# Title and labels
title_text = "Daily Caloric Intake by Age Group (2015-2019)"
xlabel_text = "Year"
ylabel_text = "Calories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits
xlim_values = (2015, 2019)
ylim_values = (1700, 2700)

# Axis labels
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = [1700, 1900, 2100, 2300, 2500, 2700]

# Axis ticks
xticks_values = years
yticks_values = [1700, 1900, 2100, 2300, 2500, 2700]

# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    child_calories,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#984ea3",
    markeredgecolor="#762a83",
    markersize=10,
    color="#762a83",
    label=label_child,
)
plt.plot(
    years,
    teen_calories,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff7f00",
    markeredgecolor="#e66101",
    markersize=10,
    color="#e66101",
    label=label_teen,
)
plt.plot(
    years,
    adult_calories,
    "^--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#377eb8",
    markeredgecolor="#225ea8",
    markersize=10,
    color="#225ea8",
    label=label_adult,
)
plt.plot(
    years,
    senior_calories,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor="#4daf4a",
    markeredgecolor="#1b7837",
    markersize=10,
    color="#1b7837",
    label=label_senior,
)

# Filling the area under the curves
plt.fill_between(years, child_calories, teen_calories, color="#984ea3", alpha=0.2)
plt.fill_between(years, teen_calories, adult_calories, color="#ff7f00", alpha=0.2)
plt.fill_between(years, adult_calories, senior_calories, color="#377eb8", alpha=0.2)
plt.fill_between(years, senior_calories, color="#4daf4a", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis、y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

# Adding title and labels
plt.title(title_text)
plt.xlabel(xlabel_text)
plt.ylabel(ylabel_text)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_7.pdf", bbox_inches="tight")