# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Simulated data for sales revenue over months
months = np.linspace(1, 12, 12)  # 12 months
revenue = np.array([8000, 8200, 8700, 9500, 10000, 10500, 11000, 11500, 12000, 12500, 13000, 14000])
revenue_pred = revenue + np.random.normal(0, 500, len(revenue))
profit_margin = np.linspace(0.10, 0.25, 12)
profit_margin_pred = profit_margin + np.random.uniform(-0.01, 0.01, len(profit_margin))

# Extracted variables
revenue_label = "Actual Revenue"
revenue_pred_label = "Predicted Revenue"
profit_margin_label = "Actual Profit Margin"
profit_margin_pred_label = "Predicted Profit Margin"
revenue_ylabel = "Revenue (USD)"
profit_margin_xlabel = "Months"
profit_margin_ylabel = "Profit Margin"
legend_labels = ["Actual", "Predicted"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
revenue_ylim = [0, 15000]
revenue_xlim = [1, 12]
revenue_yticks = [0, 5000, 10000, 15000]
revenue_xticks = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
profit_margin_ylim = [0, 0.30]
profit_margin_xlim = [1, 12]
profit_margin_yticks = [0.00, 0.10, 0.20, 0.30]
profit_margin_xticks = revenue_xticks
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Plot Revenue
ax1.plot(months, revenue, "o-", color="#d62728", label=revenue_label)
ax1.fill_between(months, revenue, color="#f2d0d0", alpha=0.5)
ax1.plot(months, revenue_pred, "s-", color="#9467bd", label=revenue_pred_label)
ax1.fill_between(months, revenue_pred, color="#e1daf5", alpha=0.5)
ax1.set_ylim(revenue_ylim)
ax1.set_xlim(revenue_xlim)
ax1.set_yticks(revenue_yticks)
ax1.set_xticks(revenue_xticks)
ax1.set_ylabel(revenue_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Profit Margin
ax2.plot(months, profit_margin, "o-", color="#d62728", label=profit_margin_label)
ax2.fill_between(months, profit_margin, color="#f2d0d0", alpha=0.5)
ax2.plot(months, profit_margin_pred, "s-", color="#9467bd", label=profit_margin_pred_label)
ax2.fill_between(months, profit_margin_pred, color="#e1daf5", alpha=0.5)
ax2.set_ylim(profit_margin_ylim)
ax2.set_xlim(profit_margin_xlim)
ax2.set_yticks(profit_margin_yticks)
ax2.set_xticks(profit_margin_xticks)
ax2.set_xlabel(profit_margin_xlabel)
ax2.set_ylabel(profit_margin_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
red_line = mlines.Line2D(
    [], [], color="#d62728", marker="o", markersize=6, label=legend_labels[0]
)
purple_line = mlines.Line2D(
    [], [], color="#9467bd", marker="s", markersize=6, label=legend_labels[1]
)
plt.legend(
    handles=[red_line, purple_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=2,
    frameon=False,
)


# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_8.pdf", bbox_inches="tight")
