
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample data
# Data
annotators = ["Physics", "Chemistry", "Biology", "Mathematics", "Computer", "Engineering"]
scores = {
    "Physics": [20, 25, 30, 35, 40],          
    "Chemistry": [30, 25, 35, 40, 20],        
    "Biology": [40, 35, 20, 25, 30],           
    "Mathematics": [25, 30, 40, 20, 35],      
    "Computer": [35, 40, 25, 30, 20],  
    "Engineering": [25, 30, 35, 20, 40],     
}

# Colors for each score
colors = ["#cd4231", "#ed9264", "#f8df9a", "#d6e8e5", "#9bbdde"]

# Variables for plot configuration
title = "Department Performance Over Quarters"
xlabel = "Departments"
ylabel = "Performance Scores"
ylim = (0, 140)
yticks = [0, 30, 60, 90, 120, 150]
legend_title = "Years"
legend_labels = ["2016", "2017", "2018", "2019", "2020"]
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.1)
legend_reverse = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the stacked bar chart
fig, ax = plt.subplots(
    figsize=(8, 5)
)  # Adjusting figure size to match original image dimensions

for i, annotator in enumerate(annotators):
    bottom = 0
    for j, score in enumerate(scores[annotator]):
        ax.bar(annotator, score, bottom=bottom, color=colors[j])
        bottom += score

# Adding title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('bar_15.pdf', bbox_inches='tight')
