
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plots
roles = ["Researcher", "Analyst", "Engineer"]
counts_s1 = np.array([[200, 400, 100], [350, 150, 200], [300, 100, 300]])  # Each row sums to 700
counts_s2 = np.array([[180, 320, 200], [240, 260, 200], [290, 230, 180]])  # Each row sums to 700

# Colors for the bars
colors = ["skyblue", "gold", "lightcoral"]
width = 0.3

# Variables for plot configuration
xlim_value = (0, 700)
xlabel_value = "Task Count"
ylabel_value = "Role"
xticks_value = [0, 100, 200, 300, 400, 500, 600, 700]
yticks_value = roles
title_s1 = "Task Distribution in Scenario 1"
title_s2 = "Task Distribution in Scenario 2"
legend_labels = ["Data Collection", "Analysis", "Reporting"]
fig_title = "Task Distribution Comparison for Different Roles"
fontsize_title = 16

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with shared x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 6), sharex=True)

# Function to plot stacked bars
def plot_stacked_bars(ax, counts, roles, colors):
    bottom = np.zeros(len(roles))
    for i in range(counts.shape[1]):
        ax.barh(
            roles, counts[:, i], height=width, zorder=5, left=bottom, color=colors[i]
        )
        bottom += counts[:, i]

# Plot for s1
plot_stacked_bars(ax1, counts_s1, roles, colors)
ax1.set_title(title_s1, y=1.2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value)
ax1.invert_yaxis()  # Invert y-axis to match the picture
ax1.grid(True, alpha=0.7)  # Add grid lines
ax1.set_xlim(*xlim_value)
ax1.tick_params(axis="y", which="both", length=0)
ax1.tick_params(axis="x", which="both", color="gray")

# Plot for s2
plot_stacked_bars(ax2, counts_s2, roles, colors)
ax2.set_title(title_s2)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.set_xlim(*xlim_value)
ax2.invert_yaxis()  # Invert y-axis to match the picture
ax2.grid(True, alpha=0.7)  # Add grid lines
ax2.tick_params(axis="y", which="both", length=0)
ax2.tick_params(axis="x", which="both", color="gray")

# Legend
ax1.legend(
    legend_labels,
    bbox_to_anchor=(0.5, 1.2),
    loc="upper center",
    ncol=3,
    frameon=False,
)

# Set x-axis ticks after all plots
ax1.set_xticks(xticks_value)
ax2.set_xticks(xticks_value)
ax1.tick_params(axis="x", which="both", bottom=True, top=False, labelbottom=True)

# Title for the whole figure
fig.suptitle(fig_title, fontsize=fontsize_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig('bar_16.pdf', bbox_inches='tight')
