import matplotlib.pyplot as plt
import matplotlib.ticker as ticker
import numpy as np; np.random.seed(0)

np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
co2_levels = np.array([280, 300, 320, 340, 360, 380, 400, 420, 440, 460, 480])  # CO2 levels in ppm
solar_activity = np.array([0.75, 0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1, 1.15, 1.2, 1.25])  # Solar activity index
volcanic_activity = np.array([-150.0, -120.0, -90.0, -60.0, -30.0, 0.0, 30.0, 60.0, 90.0, 120.0, 150.0])  # Volcanic activity index

temp_change_co2_model1 = np.array([-0.12, -0.11, -0.09, -0.06, -0.03, 0.02, 0.04, 0.06, 0.09, 0.13, 0.17])  # °C per decade
temp_change_solar_model1 = np.array([0.13, 0.17, 0.23, 0.27, 0.32, 0.35, 0.38, 0.42, 0.45, 0.48, 0.52])  # °C per decade
temp_change_volcanic_model1 = np.array([-0.28, -0.23, -0.19, -0.14, -0.08, -0.03, 0.01, 0.06, 0.12, 0.17, 0.21])  # °C per decade

temp_change_co2_model2 = np.array([-0.14, -0.13, -0.10, -0.08, -0.06, -0.03, 0.02, 0.05, 0.08, 0.11, 0.15])  # °C per decade
temp_change_solar_model2 = np.array([0.10, 0.14, 0.19, 0.23, 0.27, 0.30, 0.33, 0.37, 0.40, 0.43, 0.46])  # °C per decade
temp_change_volcanic_model2 = np.array([-0.22, -0.18, -0.14, -0.11, -0.07, -0.02, 0.03, 0.07, 0.11, 0.15, 0.19])  # °C per decade

# Extracted variables
label_model1 = "Climate Model 1"
label_model2 = "Climate Model 2"
xlabel_co2 = "CO2 Levels (ppm)"
ylabel_temp_change = "Rate of Temperature Change (°C/decade)"
xlabel_solar = "Solar Activity Index"
xlabel_volcanic = "Volcanic Activity Index"
ylim_co2 = (-0.2, 0.2)
xlim_co2 = (275, 485)
yticks_co2 = [-0.2, -0.1, 0.0, 0.1, 0.2]
xticks_co2 = [280, 300, 320, 340, 360, 380, 400, 420, 440, 460, 480]
ylim_solar = (0.1, 0.5)
xlim_solar = (0.7, 1.3)
yticks_solar = [0.1, 0.2, 0.3, 0.4, 0.5]
xticks_solar = [0.75, 0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1, 1.15, 1.2, 1.25]
ylim_volcanic = (-0.35, 0.35)
xlim_volcanic = (-165, 165)
yticks_volcanic = [-0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3]
xticks_volcanic = [-150, -120, -90, -60, -30, 0, 30, 60, 90, 120, 150]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(3, 1, figsize=(6, 10))

# Top chart - Brightness
axs[0].bar(
    co2_levels - 4,
    temp_change_co2_model1,
    width=8,
    zorder=10,
    color="#4c4cf6",
    label=label_model1,
)
axs[0].bar(
    co2_levels + 4,
    temp_change_co2_model2,
    width=8,
    zorder=10,
    color="#b2b2fa",
    label=label_model2,
)
axs[0].set_xlabel(xlabel_co2)
axs[0].set_ylabel(ylabel_temp_change)
axs[0].set_ylim(ylim_co2)
axs[0].set_xlim(xlim_co2)
axs[0].set_yticks(yticks_co2)
axs[0].xaxis.set_major_locator(ticker.FixedLocator(xticks_co2))
axs[0].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x}"))
offsetticks2 = [0.45] + [i + 10 for i in xticks_co2]
axs[0].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks2))
axs[0].grid(True, which="minor", axis="x", color="gray")
axs[0].grid(True, which="major", axis="y", color="gray")
axs[0].tick_params(axis="x", which="major", length=0)

# Middle chart - Scale
axs[1].bar(
    solar_activity - 0.01,
    temp_change_solar_model1,
    width=0.02,
    zorder=10,
    color="#4c4cf6",
)
axs[1].bar(
    solar_activity + 0.01,
    temp_change_solar_model2,
    width=0.02,
    zorder=10,
    color="#b2b2fa",
)
axs[1].set_xlabel(xlabel_solar)
axs[1].set_ylabel(ylabel_temp_change)
axs[1].set_ylim(ylim_solar)
axs[1].set_xlim(xlim_solar)
axs[1].set_yticks(yticks_solar)
axs[1].xaxis.set_major_locator(ticker.FixedLocator(xticks_solar))
axs[1].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{x}"))
offsetticks1 = [0.725] + [i + 0.025 for i in xticks_solar]
axs[1].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks1))
axs[1].grid(True, which="minor", axis="x", color="gray")
axs[1].grid(True, which="major", axis="y", color="gray")
axs[1].tick_params(axis="x", which="major", length=0)

# Bottom chart - Rotation Angle
axs[2].bar(
    volcanic_activity - 5,
    temp_change_volcanic_model1,
    width=10,
    zorder=10,
    color="#4c4cf6",
)
axs[2].bar(
    volcanic_activity + 5,
    temp_change_volcanic_model2,
    width=10,
    zorder=10,
    color="#b2b2fa",
)
axs[2].set_xlabel(xlabel_volcanic)
axs[2].set_ylabel(ylabel_temp_change)
axs[2].set_ylim(ylim_volcanic)
axs[2].set_xlim(xlim_volcanic)
axs[2].set_yticks(yticks_volcanic)
axs[2].tick_params(axis="x", which="major", length=0)

axs[2].xaxis.set_major_locator(ticker.FixedLocator(xticks_volcanic))
axs[2].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
offsetticks = [-165, -135, -105, -75, -45, -15, 15, 45, 75, 105, 135, 165]
axs[2].xaxis.set_minor_locator(ticker.FixedLocator(offsetticks))
axs[2].grid(True, which="minor", axis="x", color="gray")
axs[2].grid(True, which="major", axis="y", color="gray")

# Add legend
fig.legend(loc="upper center", ncol=2, bbox_to_anchor=(0.5, 1.03), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_22.pdf", bbox_inches="tight")