import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data

# Different types of cyber threats and their incident rates
threats = [
    "Phishing",
    "Malware",
    "Ransomware",
    "DDoS",
    "SQL Injection",
    "Man-in-the-Middle",
    "Zero-Day",
    "Cross-Site Scripting",
]
incident_rate = [0.512, 0.701, 0.468, 0.353, 0.484, 0.279, 0.547, 0.364]
colors = [
    "#3f5e8a",
    "#41778c",
    "#478f8c",
    "#51a686",
    "#69bd78",
    "#8fcf63",
    "#c4de50",
    "#fae856",
]
ylabel = "Incident Rate"
xticks = np.arange(len(threats))
xlabel = "Cyber Threats"
ylim = [0, 1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart
fig, ax = plt.subplots(figsize=(8, 4))
bars = ax.bar(threats, incident_rate, color=colors)

# Add incident_rate values on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval,
        round(yval, 3),
        ha="center",
        va="bottom",
    )

# Set axis labels and title
ax.set_ylabel(ylabel)
ax.set_xticks(xticks)
ax.set_xticklabels(threats, rotation=45, ha="center")
ax.set_xlabel(xlabel)

ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('bar_24.pdf', bbox_inches='tight')
