import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Updated data
datasets = ["Urban Transport", "Rural Transport"]
electric = [2.7, 3.4]
hybrid = [1.9, 2.1]
diesel = [3.5, 2.8]

# X-axis positions
x = np.arange(len(datasets))

# Bar width
width = 0.2
labels = ["Electric", "Hybrid", "Diesel"]
ylim = [0, 4.5]
ylabel = "Fuel Efficiency (km/l)"
xlabel = "Transport Types"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(6, 5)
)  # Adjusting figure size to match the original image's dimensions
ax.bar(
    x - width, electric, width, label=labels[0], hatch="//", edgecolor="black", color="white"
)
ax.bar(
    x,
    hybrid,
    width,
    label=labels[1],
    hatch="..",
    edgecolor="black",
    color="white",
)
ax.bar(
    x + width, diesel, width, label=labels[2], hatch="xx", edgecolor="black", color="white"
)

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(datasets)
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_28.pdf', bbox_inches='tight')
