import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
# Data for each subplot
datasets = ["Refrigerator", "Washing Machine", "Microwave", "Vacuum Cleaner"]
models = ["Basic Model", "Advanced Model", "ML Model", "Comprehensive Analysis"]
colors = ["#5377ca", "#e08a57", "#91c4df", "#d1bc73"]
PLCC_data = {
    "Refrigerator": [0.854, 0.868, 0.866, 0.872],
    "Washing Machine": [0.890, 0.895, 0.900, 0.915],
    "Microwave": [0.815, 0.825, 0.830, 0.840],
    "Vacuum Cleaner": [0.880, 0.886, 0.890, 0.892],
}
SROCC_data = {
    "Refrigerator": [0.856, 0.870, 0.868, 0.870],
    "Washing Machine": [0.895, 0.900, 0.905, 0.919],
    "Microwave": [0.800, 0.810, 0.815, 0.825],
    "Vacuum Cleaner": [0.886, 0.890, 0.894, 0.894],
}
lims = [(0.850, 0.880), (0.885, 0.920), (0.800, 0.845), (0.875, 0.895)]
label = ["PLCC", "SROCC"]
ylabel = "Satisfaction Ratings"
title = "Customer Satisfaction Analysis by Models"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(10, 3))

# Plot each subplot
for i, dataset in enumerate(datasets):
    x = [3, 6]  # the label locations
    width = 0.5  # the width of the bars
    for j in range(len(PLCC_data)):
        # PLCC bars
        axs[i].bar(
            x[0] + (j - 1.5) * width,
            PLCC_data[dataset][j],
            width,
            label=label[0],
            color=colors[j],
            edgecolor="white",
        )
        # SROCC bars
        axs[i].bar(
            x[1] + (j - 1.5) * width,
            SROCC_data[dataset][j],
            width,
            label=label[1],
            color=colors[j],
            edgecolor="white",
        )

    # Add some text for labels, title and custom x-axis tick labels, etc.
    axs[i].set_ylabel(ylabel)
    axs[i].set_ylim(lims[i][0], lims[i][1])
    axs[i].set_title(dataset)
    axs[i].set_xticks(x)
    axs[i].set_xticklabels(label)

# Add legend
legend_handles = [
    mpatches.Patch(color=color, label=label) for color, label in zip(colors, models)
]
# Create legend
fig.legend(
    handles=legend_handles,
    loc="upper center",
    title=title,
    ncol=4,
    bbox_to_anchor=(0.5, 1.15),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('bar_3.pdf', bbox_inches='tight')
