import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Updated data
methods = ["K-Means", "Random Forest", "Neural Network"]
efficiency = [78.4, 88.9, 92.3]
accuracy = [82.1, 91.5, 94.8]
precision = [75.0, 89.7, 93.2]

# X-axis positions
x = np.arange(len(methods))

# Bar width
bar_width = 0.2
gap_width = 0.02

labels = ["Efficiency", "Accuracy", "Precision"]
ylabel = "Performance Metrics (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting bars
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusting figure size to match 468x360 pixels
rects1 = ax.bar(
    x - bar_width - gap_width, efficiency, bar_width, label=labels[0], color="#f2a49e"
)
rects2 = ax.bar(x, accuracy, bar_width, label=labels[1], color="#a9c8f0")
rects3 = ax.bar(
    x + bar_width + gap_width, precision, bar_width, label=labels[0], color="#cdbcfa"
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_xticks(x)
ax.set_xticklabels(methods)
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3)


# Adding data labels inside the bars
def autolabel(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height + 2),
            xytext=(0, 0),  # No offset
            textcoords="offset points",
            ha="center",
            va="center",
            color="black",
            fontsize=8,
        )


autolabel(rects1)
autolabel(rects2)
autolabel(rects3)

# Adjusting the layout and font sizes
ax.tick_params(axis="x", labelsize=8)
ax.tick_params(axis="y", labelsize=8)
ax.yaxis.label.set_size(8)

# Adding grid
ax.grid(axis="y", linestyle="--", alpha=0.6)
ax.grid(axis="x", linestyle="--", alpha=0.6)
ax.set_axisbelow(True)

plt.subplots_adjust(bottom=0.2, top=0.95)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_30.pdf', bbox_inches='tight')
