
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
methods = ["Random", "City Cycle", "Highway Cycle", "Combined Cycle", "EPA Test"]
fuel_efficiency_sedan = [25.4, 24.8, 33.1, 29.5, 28.7]
fuel_efficiency_suv = [19.2, 18.7, 24.3, 21.0, 20.5]
index = [6, 12]
# Limits, labels, and title for the plot
ylim_values = (15.0, 35.0)
ylabel_value = "Average Fuel Efficiency (MPG)"
xtickslabel_values = ["Sedan", "SUV"]

# no change
# Colors (approximated from the image)
colors = ["#837ba8", "#aa6262", "#6e9d72", "#c38c6a", "#5e74a0"]
# Labels for legend and plot type
labels = methods
xticks_values = index
# X-axis positions
# Bar width
bar_width = 1
r1 = np.arange(len(methods))
r2 = [x + bar_width + len(r1) for x in r1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 5))
# Create bars
for i in range(len(r1)):
    plt.bar(
        index[0] + (i - 2) * bar_width,
        fuel_efficiency_sedan[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=labels[i],
    )

for i in range(len(r2)):
    plt.bar(
        index[1] + (i - 2) * bar_width,
        fuel_efficiency_suv[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
    )

# Add text on top of the bars
for i in range(len(r1)):
    plt.text(
        index[0] + (i - 2) * bar_width,
        fuel_efficiency_sedan[i] + 0.05,
        str(fuel_efficiency_sedan[i]),
        ha="center",
    )
    plt.text(
        index[1] + (i - 2) * bar_width,
        fuel_efficiency_suv[i] + 0.05,
        str(fuel_efficiency_suv[i]),
        ha="center",
    )

# General layout
plt.xticks(xticks_values, xtickslabel_values)
plt.ylabel(ylabel_value)
plt.ylim(*ylim_values)
plt.legend(loc="upper center", ncol=5, bbox_to_anchor=(0.5, 1.1), frameon=False)

plt.tick_params(axis="x", which="both", length=0)
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_35.pdf', bbox_inches='tight')
