
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
# Data
# Data
foods = ["Apple", "Banana", "Orange"]
blood_sugar_change = {
    "0 min": [0.0, 0.0, 0.0],
    "15 min": [5.0, 12.0, 7.0],
    "30 min": [8.0, 20.0, 12.0],
    "45 min": [7.5, 15.0, 10.0],
    "60 min": [5.0, 10.0, 8.0],
    "75 min": [3.0, 8.0, 5.0],
    "90 min": [1.0, 5.0, 2.0],
}

# Plot labels and types
ylabel_text = "Blood Sugar Change (%)"
xlabel_text = "Foods"
title_text = "Blood Sugar Change Over Time by Food Type"
legend_title = "Time Interval"
bar_label_fontsize = 10
ylabel_fontsize = 12

# Plot limits and ticks
ylim_values = (0, 25)
yticks_values = [0, 5, 10, 15, 20, 25]


# Colors for the bars
colors = ["#de9aa4", "#bc9c58", "#8ea654", "#65ab91", "#67a9b6", "#a3ade5", "#da8fdc"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Setup the figure and axes
fig, ax = plt.subplots(figsize=(12, 4))

# Bar width
bar_width = 0.1

# Positions of the bars on the x-axis
r = np.arange(len(foods))

# Create bars for each perturbation
for i, (perturbation, values) in enumerate(blood_sugar_change.items()):
    ax.bar(
        r + i * bar_width,
        values,
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=perturbation,
    )

# Add labels on top of the bars
for i, (perturbation, values) in enumerate(blood_sugar_change.items()):
    for j, value in enumerate(values):
        ax.text(
            j + i * bar_width,
            value + 0.1,
            str(value),
            ha="center",
            va="bottom",
            fontsize=bar_label_fontsize,
        )

# General layout
ax.set_ylabel(ylabel_text, fontsize=ylabel_fontsize)
ax.set_xticks(r + bar_width * (len(blood_sugar_change) - 1) / 2)
ax.set_xticklabels(foods)
ax.set_ylim(*ylim_values)
ax.set_yticks(yticks_values)
ax.legend(
    title=legend_title,
    loc="upper center",
    bbox_to_anchor=(0.5, 1.2),
    frameon=False,
    ncol=7,
)
ax.set_facecolor("#eaeaf2")
ax.yaxis.grid(True, color="white")
ax.set_axisbelow(True)

# Remove spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.spines["left"].set_visible(False)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
fig.set_size_inches(12, 4)
plt.tick_params(axis="both", which="both", length=0)
plt.tight_layout()
plt.savefig('bar_37.pdf', bbox_inches='tight')
