import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
annotators = ["Surveyor 1", "Surveyor 2", "Surveyor 3", "Surveyor 4", "Surveyor 5", "Surveyor 6"]
scores = {
    "Surveyor 1": [20, 22, 18, 23, 22],
    "Surveyor 2": [18, 20, 19, 24, 24],
    "Surveyor 3": [17, 21, 20, 22, 25],
    "Surveyor 4": [19, 18, 21, 23, 24],
    "Surveyor 5": [21, 19, 22, 20, 23],
    "Surveyor 6": [20, 21, 19, 22, 23],
}

title = "Surveyor Data Collection Accuracy"
xlabel = "Surveyor"
ylabel = "Accuracy Scores"

ylim = [0, 105]
yticks = range(0, 106, 15)
score_labels = [f"Round {i+1}" for i in range(5)]
legendtitle = "Survey Rounds"

# Define a color map for gradients
cmap = plt.get_cmap("BuGn")

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 5))  # Adjusting figure size

for i, annotator in enumerate(annotators):
    bottom = 0
    score_list = scores[annotator]
    for j, score in enumerate(score_list):
        color = cmap(
            1 - j / len(score_list)
        )  # Determine color based on position in list
        bar = ax.bar(annotator, score, bottom=bottom, color=color)
        bottom += score
        # Annotate each segment

        if j == len(score_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with score indications

ax.legend(score_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left")
ax.yaxis.grid(linestyle="--")

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_70.pdf', bbox_inches='tight')
