import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the boxplots representing annual population growth rates (%) for different countries
data = [
    np.array([0.93, 1.32, 1.05, 0.85, 1.19, 1.33, 1.22, 1.29, 1.01, 1.09]),
    np.array([0.73, 0.86, 0.67, 0.31, 1.07, 0.84, 0.35, 1.19, 0.64, 1.02]),
    np.array([0.98, 0.83, 1.08, 0.49, 0.9, 0.63, 0.58, 0.66, 0.72, 0.81]),
    np.array([1.09, 1.82, 1.66, 0.96, 2.02, 2.16, 1.91, 1.44, 1.13, 1.87]),
    np.array([1.18, 1.67, 1.36, 1.59, 1.41, 1.51, 1.3, 1.84, 1.34, 1.42]),
]

# Country labels for the x-axis
labels = ["Country A", "Country B", "Country C", "Country D", "Country E"]

# Axes Limits and Labels
ylim_values = [-0.5, 2.5]
xlabel_value = "Countries"
ylabel_value = "Annual Population Growth Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(6, 5)
)  # Adjusting figure size as per the dimensions provided
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor="#3171ad", color="black"),
    showfliers=False,
    showcaps=False,
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-", linewidth=0),
    capprops=dict(color="black", linestyle="-"),
)

ax.set_ylim(ylim_values)
# Set labels
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('box_22.pdf', bbox_inches='tight')
