import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
# Random data to simulate the boxplot values for different treatments
data_Treatment_A = np.array([77.64, 64.0, 69.79, 82.41, 78.68, 50.23, 69.5, 58.49, 58.97, 64.11, 61.44, 74.54, 67.61, 61.22, 64.44, 63.34, 74.94, 57.95, 63.13, 51.46, 34.47, 66.54, 68.64, 52.58, 82.7, 45.46, 60.46, 58.13, 75.33, 74.69, 61.55, 63.78, 51.12, 40.19, 56.52, 61.56, 72.3, 72.02, 56.13, 56.98, 49.51, 45.8, 42.94, 79.51, 54.9, 55.62, 47.47, 67.77, 43.86, 57.87, 51.05, 63.87, 54.89, 48.19, 59.72, 64.28, 60.67, 63.02, 53.66, 56.37, 53.28, 56.4, 51.87, 42.74, 61.77, 55.98, 43.7, 64.63, 50.93, 60.52, 67.29, 61.29, 71.39, 47.65, 64.02, 53.15, 51.29, 54.21, 56.88, 60.56, 48.35, 69.01, 64.66, 44.64, 74.88, 78.96, 71.79, 58.2, 49.29, 70.54, 55.97, 72.22, 62.08, 69.77, 63.56, 67.07, 60.11, 77.86, 61.27, 64.02])
data_Treatment_B = np.array([68.83, 36.52, 37.3, 59.69, 38.27, 69.44, 45.86, 42.53, 69.23, 64.81, 68.68, 59.06, 41.39, 69.1, 47.32, 58.02, 59.47, 48.45, 56.14, 59.22, 53.76, 39.01, 52.98, 63.26, 43.05, 48.5, 45.65, 68.49, 56.72, 54.07, 42.3, 55.39, 43.26, 50.32, 43.64, 56.76, 55.77, 47.92, 53.96, 39.07, 35.09, 54.39, 51.67, 56.35, 73.83, 59.44, 40.87, 61.17, 36.84, 45.38, 49.32, 67.13, 42.55, 41.74, 49.02, 43.37, 61.27, 39.2, 38.53, 45.62, 45.02, 69.3, 59.49, 50.88, 37.75, 58.44, 40.0, 34.55, 61.88, 53.17, 59.21, 53.19, 58.57, 43.49, 39.66, 56.82, 41.97, 43.1, 45.44, 50.17, 46.46, 36.25, 43.56, 27.77, 56.25, 33.98, 38.96, 50.52, 42.6, 65.43, 37.07, 52.67, 49.61, 38.32, 55.23, 48.28, 57.72, 58.24, 71.63, 63.37])
data_Treatment_C = np.array([34.46, 36.41, 56.49, 49.83, 49.6, 15.75, 39.64, 28.93, 44.2, 38.53, 53.65, 44.76, 51.79, 33.0, 25.83, 33.85, 39.74, 45.69, 73.89, 39.37, 25.66, 34.81, 33.05, 47.22, 16.89, 40.95, 42.35, 43.48, 31.04, 36.43, 18.64, 32.6, 31.86, 46.24, 22.66, 51.72, 62.42, 8.95, 46.39, 50.15, 30.44, 34.04, 38.01, 35.53, 35.36, 14.86, 57.28, 56.19, 27.8, 18.0, 47.82, 31.36, 42.13, 35.21, 50.37, 50.42, 29.12, 19.25, 16.26, 49.16, 22.17, 32.4, 31.06, 39.21, 10.96, 42.83, 47.86, 41.33, 35.34, 41.46, 45.99, -1.59, 69.34, 45.85, 30.21, 34.14, 47.41, 38.26, 9.54, 70.97, 38.34, 55.3, 29.62, 63.05, 44.3, 49.13, 24.32, 58.17, 50.35, 59.53, 30.58, 32.78, 74.56, 24.1, 37.96, 57.05, 41.47, 48.74, 34.01, 45.55])
data_Treatment_D = np.array([16.93, 46.58, 28.82, 23.2, 36.66, 25.39, 16.66, 16.53, 36.94, 28.4, 28.66, 40.78, 18.73, 22.69, 26.15, 30.94, 29.58, 27.13, 29.38, 28.93, 22.8, 21.87, 32.75, 21.09, 18.43, 26.88, 28.42, 52.57, 22.95, 39.43, 37.47, 18.11, 37.73, 18.16, 3.41, 36.06, 12.44, 34.51, 23.16, 46.6, 40.69, 25.47, 23.12, 17.86, 25.59, 27.2, 26.35, 31.57, 35.79, 33.5, 22.36, 15.62, 43.65, 23.11, 23.48, 24.79, 11.57, 25.22, 25.2, 36.2, 36.98, 30.04, 39.32, 33.4, 29.84, 31.61, 28.09, 26.05, 27.32, 18.72, 32.8, 20.07, 38.42, 27.51, 30.49, 34.94, 36.43, 14.29, 27.93, 38.8, 13.02, 33.87, 7.44, 19.77, 30.39, 13.43, 20.14, 15.28, 46.48, 31.64, 35.67, 27.77, 26.47, 13.84, 27.08, 22.39, 38.58, 41.41, 44.67, 38.53])

data = [data_Treatment_A, data_Treatment_B, data_Treatment_C, data_Treatment_D]

# Labels and Plot Types
legend_labels = ["Treatment A", "Treatment B", "Treatment C", "Treatment D"]

# Axes Limits and Labels
xticklabels = ["Treatment A", "Treatment B", "Treatment C", "Treatment D"]
ylabel_value = "Effectiveness Score"
ylim_values = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusting figure size to match original image dimensions
bp = ax.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing the boxplot colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Customizing the boxplot median lines
for median in bp["medians"]:
    median.set(color="black", linewidth=1)

legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax.legend(handles=legend_patches, loc="upper right")

# Setting the x-axis labels
ax.set_xticklabels(xticklabels)

# Setting the y-axis label
ax.set_ylabel(ylabel_value)

# Setting the y-axis limits
ax.set_ylim(ylim_values)

# Adding grid lines
ax.yaxis.grid(True, which="major", color="grey", alpha=0.5)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('box_3.pdf', bbox_inches='tight')
