# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create a grid of x and y values
x = np.linspace(-1, 1, 200)
y = np.linspace(-1, 1, 200)
X, Y = np.meshgrid(x, y)

# Adjust the lambda function to reflect a new data distribution pattern
def medical_distribution_function(X, Y):
    # Simulate medical data using Gaussian peaks representing health metrics
    return (
        np.exp(-((X - 0.3) ** 2 + (Y + 0.3) ** 2) / 0.025) * 0.7 +
        np.exp(-((X + 0.3) ** 2 + (Y - 0.3) ** 2) / 0.05) * 0.9 +
        np.exp(-((X - 0.1) ** 2 + (Y - 0.2) ** 2) / 0.03) * 0.8
    )

# Calculate the function values on the grid
Z = medical_distribution_function(X, Y)

# Extracted variables
xlabel = "X Axis"
ylabel = "Y Axis"
title = "Medical Data Distribution"
colorbar_label = "Health Metric Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

grid_linestyle = '--'
grid_alpha = 0.7
xticks_fontsize = 12
yticks_fontsize = 12
xlabel_fontsize = 14
ylabel_fontsize = 14
title_fontsize = 16

# Using a colormap that suits scientific visualization
n_colors = 10  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("plasma", n_colors)

contour = plt.contourf(X, Y, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=xlabel_fontsize)
plt.ylabel(ylabel, fontsize=ylabel_fontsize)
plt.title(title, fontsize=title_fontsize)

# Style adjustments
plt.grid(True, linestyle=grid_linestyle, alpha=grid_alpha)  # Add a grid for better readability
plt.xticks(fontsize=xticks_fontsize)
plt.yticks(fontsize=yticks_fontsize)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_10.pdf", bbox_inches="tight")