# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(10)
# Create a grid of x and y values representing temperature variations
x = np.linspace(-5, 5, 100)
y = np.linspace(-5, 5, 100)
X, Y = np.meshgrid(x, y)

# Function representing the temperature distribution influenced by different factors
def temperature_distribution(X, Y):
    return (
        np.sin(np.sqrt(X**2 + Y**2) / 2) 
        + 0.3 * np.cos(5*X) * np.sin(2*Y)
    )

# Calculate the function values on the grid
Z_values = temperature_distribution(X, Y)

# Extracted variables
xlabel = "X Position"
ylabel = "Y Position"
title = "Temperature Distribution Over Area"
colorbar_label = 'Temperature (°C)'
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(8, 6))

# Using a colormap suitable for temperature data
cmap = plt.cm.get_cmap("coolwarm")

contour = plt.contourf(X, Y, Z_values, levels=25, cmap=cmap)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Enhance grid lines for better readability
plt.grid(True, linestyle='--', alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_13.pdf", bbox_inches="tight")