# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)
# Hypothetical temperature data (°C) for a city grid over a year
x = np.linspace(0, 365, 100)  # days of the year
y = np.linspace(0, 100, 100)  # city grid in km
X, Y = np.meshgrid(x, y)
Z1 = 15 + 10 * np.exp(-((X - 100) ** 2 + (Y - 50) ** 2) / 10000)  # early year temperature
Z2 = 30 + 10 * np.exp(-((X - 200) ** 2 + (Y - 50) ** 2) / 10000)  # mid-year temperature

# Labels and texts
labels = ["Early Year", "Mid Year"]
xlabel = "Days of the Year"
ylabel = "City Grid (km)"
title = "Temperature Distribution Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Contour lines for Early Year (blue) and Mid Year (red)
CS1 = ax.contour(X, Y, Z1, colors="blue", linestyles="solid", linewidths=1.5, label=labels[0])
CS2 = ax.contour(X, Y, Z2, colors="red", linestyles="dashed", linewidths=1.5, label=labels[1])

# Labels for x and y axes and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot for better readability
ax.set_aspect("auto")
ax.grid(True)
ax.set_facecolor("#e5e5e5")
ax.set_ylim(0, 100)
ax.set_xlim(0, 365)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_14.pdf", bbox_inches="tight")