# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(2)
# Sample data to create CO2 concentration distribution contour lines
x = np.linspace(-10, 30, 150)
y = np.linspace(-30, 30, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 5) ** 2 + (Y - 3) ** 2) / 10)
Z2 = np.exp(-((X + 7) ** 2 + (Y + 6) ** 2) / 10)

# Labels and titles
labels = ["Location X", "Location Y"]
xlabel = "Longitude"
ylabel = "Latitude"
title = "CO2 Concentration Distribution"
colorbar_label = "CO2 Concentration"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Location X (cool colors) and Location Y (warm colors)
CS1 = ax.contour(X, Y, Z1, colors="blue", linestyles='dashed', linewidths=2)
CS2 = ax.contour(X, Y, Z2, colors="orange", linestyles='solid', linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=15)
ax.set_ylabel(ylabel, fontsize=15)
ax.set_title(title, fontsize=18)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=13)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True)
ax.set_facecolor("#e0e0e0")
ax.set_ylim(-30, 30)
ax.set_xlim(-10, 30)

# Add color bar to represent CO2 concentration intensity
CO2_concentration = ax.contourf(X, Y, Z1 + Z2, alpha=0.4, cmap='viridis')
cbar = fig.colorbar(CO2_concentration, ax=ax)
cbar.set_label(colorbar_label, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_16.pdf", bbox_inches="tight")