# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data: Simulate new data related to climate patterns using Gaussian functions
import numpy as np
np.random.seed(42)
X, Y = np.meshgrid(np.linspace(-10, 10, 400), np.linspace(-10, 10, 400))

# Use differently parameterized Gaussian blobs representing climate zones
Z1 = np.exp(-(((X + 3) ** 2) / 5 + ((Y - 3) ** 2) / 7))
Z2 = np.exp(-(((X - 5) ** 2) / 6 + ((Y + 1) ** 2) / 8))
Z3 = np.exp(-(((X + 6) ** 2) / 7 + ((Y - 6) ** 2) / 5))
Z4 = np.exp(-(((X - 2) ** 2) / 8 + ((Y + 5) ** 2) / 6))
Z = Z1 + Z2 + Z3 + Z4

# Extracted variables
title_text = "Climate Pattern Distribution"
xlabel_text = "Longitude"
ylabel_text = "Latitude"
colorbar_label_text = "Climate Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with labels
fig, ax = plt.subplots(figsize=(10, 8))
cnt = ax.contour(X, Y, Z, levels=15, colors="blue", linewidths=0.75)
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10, fmt="%.2f")
contour_filled = ax.contourf(X, Y, Z, levels=15, cmap='plasma')

# Title and Labels
ax.set_title(title_text)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_19.pdf", bbox_inches="tight")