import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data to create contour lines similar to the picture
temperature = np.linspace(-10, 40, 100)  # Temperature in Celsius
consumption = np.linspace(100, 1000, 100)  # Electricity consumption in MWh
Temperature, Consumption = np.meshgrid(temperature, consumption)
RegionA = np.exp(-((Temperature - 15) ** 2 + (Consumption - 550) ** 2) / 5000)
RegionB = np.exp(-((Temperature - 25) ** 2 + (Consumption - 750) ** 2) / 5000)
labels = ["Region A", "Region B"]
xlabel = "Temperature (°C)"
ylabel = "Electricity Consumption (MWh)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 8))

# Contour lines for Region A (blue) and Region B (red)
CS1 = ax.contour(Temperature, Consumption, RegionA, colors="blue", label=labels[0])
CS2 = ax.contour(Temperature, Consumption, RegionB, colors="red", label=labels[1])

# Labels for x and y axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot to match the original image
ax.set_aspect("auto")
ax.grid()
ax.set_facecolor("#e8e8e8")
ax.set_ylim(100, 1000)
ax.set_xlim(-10, 40)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('contour_3.pdf', bbox_inches='tight')
