import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Generate data for the plot
years = np.linspace(2000, 2020, 1000)
renewable_energy_production = [
    np.random.uniform(20, 150)
    * np.exp(-0.8 * (years - year) ** 1.5 / np.linspace(2, 5, 9)[index])
    for index, year in enumerate(np.linspace(2005, 2015, 9))
]
cbar_label = "Years"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 3))

# Create a colorbar
sm = plt.cm.ScalarMappable(cmap="coolwarm", norm=plt.Normalize(vmin=2000, vmax=2020))
cbar = plt.colorbar(sm, ax=ax, label=cbar_label)
cbar.set_label(cbar_label, rotation=270, labelpad=15)

for i in range(9):
    plt.fill_between(years, renewable_energy_production[i], color=plt.cm.coolwarm(i / 9), alpha=0.9)
plt.ylim(0, 200)
# Remove the plot border
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(True)
plt.gca().spines["left"].set_visible(False)
plt.gca().set_yticks([])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('density_1.pdf', bbox_inches='tight')
