# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Create some data representing the number of technological innovations per year
years = np.linspace(2000, 2023, 240)
innovations = 50 + 30 * np.sin(years / 2)
patent_applications = 100 + 40 * np.cos(years / 3)

# Define plot labels and title
xlabel = 'Year'
ylabel = 'Number of Units'
title = 'Technological Innovations and Patent Applications (2000-2023)'
legend_innovations = 'Innovations (units)'
legend_patent_applications = 'Patent Applications (units)'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the data
ax.plot(years, innovations, color="red", lw=2, label=legend_innovations)
ax.plot(years, patent_applications, color="blue", lw=2, label=legend_patent_applications)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

ax.set_ylim(0, 200)
ax.set_xlim(2000, 2023)

# Add labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend()

# Add grid lines for better readability
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_10.pdf", bbox_inches="tight")