# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Create some data representing blood pressure and heart rate over time
time = np.linspace(0, 24, 100)
blood_pressure = 120 + 10 * np.sin(np.pi * time / 12)
heart_rate = 70 + 15 * np.sin(np.pi * time / 6)

# Extracted strings
xlabel_text = 'Time of Day (hours)'
ylabel_text = 'Values'
title_text = 'Blood Pressure and Heart Rate over Time'
legend_bp_label = 'Blood Pressure (mmHg)'
legend_hr_label = 'Heart Rate (bpm)'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 5))  # Setting a figure size that’s suitable for the new data

# Plot the data
ax.plot(time, blood_pressure, color="red", linestyle='-', linewidth=2, label=legend_bp_label)
ax.plot(time, heart_rate, color="blue", linestyle='--', linewidth=2, label=legend_hr_label)

# Customize the plot to make it visually appealing and informative
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

# Adding grid lines for better readability
ax.grid(True, linestyle=':', alpha=0.5)

# Adding labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Adding a legend
ax.legend(loc='upper left')

# Set y-limits to ensure the plot is within a specific range
ax.set_ylim(50, 150)

# Set x-limits to focus on the 24 hours period
ax.set_xlim(0, 24)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_12.pdf", bbox_inches="tight")