# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Create medical data
years = np.linspace(2000, 2020, 100)  # Years from 2000 to 2020
vaccination_rate = np.exp(-0.003 * (years - 2010) ** 2)  # Vaccination rate peaks around year 2010
disease_infection_rate = 0.9 * np.exp(-0.004 * (years - 2005) ** 2)  # Disease infection rate peaks around year 2005

# Extracted strings
xlabel_text = "Year"
ylabel_text = "Rate"
title_text = "Vaccination and Disease Infection Rates Over the Years"
legend_vaccination_label = 'Vaccination Rate'
legend_disease_label = 'Disease Infection Rate'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
legend_location = 'upper right'

# Plot the data
ax.fill_between(years, vaccination_rate, color="purple", edgecolor="#800080", alpha=0.6, label=legend_vaccination_label)
ax.fill_between(years, disease_infection_rate, color="orange", edgecolor="#ffa500", alpha=0.6, label=legend_disease_label)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)
ax.set_ylim(0, 1)

# Add legend
ax.legend(loc=legend_location)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_13.pdf", bbox_inches="tight")