# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Set random seed for reproducibility
np.random.seed(42)

# Generate a normal distribution simulating medical data (e.g., blood pressure measurements)
data1 = np.random.normal(loc=120, scale=15, size=400)
data2 = np.random.normal(loc=140, scale=20, size=250)
medical_data = np.concatenate([data1, data2])
xs = np.linspace(60, 200, 300)

# Axes Limits and Labels
title = "KDE Plot of Blood Pressure Measurements"
xlabel_value = "Blood Pressure (mmHg)"
ylabel_value = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 5))

xticks_values = [60, 80, 100, 120, 140, 160, 180, 200]
xticklabels = ["60", "80", "100", "120", "140", "160", "180", "200"]
yticks_values = [0, 0.005, 0.01, 0.015, 0.02]
yticklabels = ["0.0", "0.005", "0.01", "0.015", "0.02"]
xlim_values = [60, 200]
ylim_values = [0, 0.025]


# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(medical_data)
density.covariance_factor = lambda: 0.25
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#ffe4e1", edgecolor="darkred")

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_15.pdf", bbox_inches="tight")