import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Create some data representing health metrics over time
time = np.linspace(0, 20, 100)
treatment_a = 30 - 10 * np.exp(-0.1 * (time - 5) ** 2)
treatment_b = 30 - 8 * np.exp(-0.15 * (time - 8) ** 2)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 4))  # Adjusted to match the dimensions in pixels

# Plot the data
ax.fill_between(time, treatment_b, color="pink", edgecolor="#be6373", alpha=0.5)

# Customize the plot to match the picture
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(False)
ax.tick_params(left=False, labelleft=False, bottom=False, labelbottom=False)

ax.set_ylim(10, 35)
ax.set_xlim(0, 20)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('density_2.pdf', bbox_inches='tight')
