# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)  # Using a different seed for varied data
# Generate data for the plot
x = np.linspace(0, 14, 800)  # Time in months
# Simulated revenue data for seven different products
y = [
    np.random.uniform(10, 50)
    * np.cos(0.2 * (x - i))
    for index, i in enumerate(np.linspace(0, 6, 7))
]

# Labels and titles
cbar_label = "Product"
x_label = "Months"
y_label = "Revenue Change"
plot_title = "Revenue Change of Different Products Over Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(12, 5))

# Create a colorbar
sm = plt.cm.ScalarMappable(cmap="coolwarm", norm=plt.Normalize(vmin=0, vmax=6))
cbar = plt.colorbar(sm, ax=ax, label=cbar_label)
cbar.set_label(cbar_label, rotation=270, labelpad=20)

# Plot each product's revenue trend
for i in range(7):
    plt.plot(
        x, y[i], color=plt.cm.coolwarm(i / 7), alpha=0.8, label=f"Product {i+1}"
    )

plt.ylim(-50, 60)
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.title(plot_title)

# Remove top and right plot borders and set major grid lines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().xaxis.set_major_locator(plt.MaxNLocator(integer=True))
plt.grid(True, which='major', axis='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_6.pdf", bbox_inches="tight")