# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)
# Generate data for the plot
x = np.linspace(0, 15, 600)  # Simulate time progression
# Generate stock index data with some variations
y = [
    np.random.uniform(200, 300) + np.cos(x - i)*np.random.uniform(10, 50) 
    for index, i in enumerate(np.linspace(0, 15, 7))
]

# Text variables
cbar_label = "Stock Index Value"
plot_title = "Stock Index Value Fluctuations Over Time"
x_label = "Time (days)"
y_label = "Stock Index Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the preferred dimensions
fig, ax = plt.subplots(figsize=(12, 7))

# Create a colorbar
sm = plt.cm.ScalarMappable(cmap="viridis", norm=plt.Normalize(vmin=200, vmax=350))
cbar = plt.colorbar(sm, ax=ax, label=cbar_label)
cbar.set_label(cbar_label, rotation=270, labelpad=20)

# Plotting the data
for i in range(7):
    plt.fill_between(x, y[i], color=plt.cm.viridis(i / 7), alpha=0.6)

plt.ylim(150, 350)
plt.title(plot_title)
plt.xlabel(x_label)
plt.ylabel(y_label)

# Customize spines to enhance visual appeal
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(True)
plt.gca().spines["left"].set_visible(False)
plt.gca().set_yticks([])

# ===================
# Part 4: Saving Output
# ===================
# Display plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_8.pdf", bbox_inches="tight")