import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data (replace with actual values)
configurations = [
    "Solar / 5kW / 30°",
    "Solar / 5kW / 45°",
    "Solar / 10kW / 30°",
    "Solar / 10kW / 45°",
    "Wind / 3MW / 80m",
    "Wind / 3MW / 100m",
    "Wind / 5MW / 80m",
    "Wind / 5MW / 100m",
    "Hydro / 1MW / 10m",
    "Hydro / 1MW / 15m",
    "Hydro / 2MW / 10m",
    "Hydro / 2MW / 15m",
    "Biomass / 1MW / 50%",
    "Biomass / 1MW / 70%",
    "Biomass / 2MW / 50%",
    "Biomass / 2MW / 70%",
    "Geothermal / 1MW / 150°C",
    "Geothermal / 1MW / 200°C",
]
solid_bar_values = np.array([54.88, 71.52, 60.28, 54.49, 42.37, 64.59, 43.76, 89.18, 96.37, 38.34, 79.17, 52.89, 56.80, 92.56, 7.10, 8.71, 2.02, 83.26])  # Efficiency percentage
striped_bar_values = np.array([77.82, 87.00, 97.86, 79.92, 46.15, 78.05, 11.83, 63.99, 14.34, 94.47, 52.18, 41.47, 26.46, 77.42, 45.62, 56.84, 1.88, 61.76])  # Efficiency percentage
error = np.array([2.74, 3.58, 3.01, 2.72, 2.12, 3.23, 2.19, 4.46, 4.82, 1.92, 3.96, 2.64, 2.84, 4.63, 0.36, 0.44, 0.10, 4.16])  # Error percentage


# Labels and Plot Types
label_Striped = "Configuration A"
label_Solid = "Configuration B"

# Axes Limits and Labels
xlabel_value = "Efficiency (%)"
ylabel_value = "Configurations"
title = "Renewable Energy Source Configurations and Efficiency"
ylim_values = [-0.4, 17.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 10))

# Create grouped bar chart with error bars
bar_width = 0.4
index = np.arange(len(configurations))
plt.barh(
    index - 0.2,
    striped_bar_values,
    bar_width,
    color="#d8d7db",
    hatch="//",
    xerr=error,
    label=label_Striped,
    capsize=3,
    edgecolor="black",
    alpha=0.6,
)
plt.barh(
    index + 0.2,
    solid_bar_values,
    bar_width,
    color="#ebb08c",
    hatch="",
    xerr=error,
    label=label_Solid,
    capsize=3,
    edgecolor="black",
    alpha=0.6,
)

# Add labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.yticks(index, configurations, rotation=0)
plt.gca().set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('errorbar_3.pdf', bbox_inches='tight')
