import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(42)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data (replace with actual data)
activities = [
    "Exercise",
    "Meditation",
    "Sleep",
    "Healthy Eating",
    "Work-life Balance",
    "Medical Checkups",
]
means = np.array([0.0875, 0.1451, 0.1232, 0.1099, 0.0656, 0.0656])
std_devs = np.array([0.0123, 0.0446, 0.034, 0.0383, 0.0108, 0.0488])
dataset_mean = np.float64(0.0994)

# Labels and Plot Types
label_Mean = "Mean"
label_Dataset_mean = "Dataset Mean"

# Axes Limits and Labels
ylabel_value = "Time Spent (Fraction of total time)"
ylim_values = [0.01, 0.18]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Error bar plot
ax.errorbar(
    activities,
    means,
    yerr=std_devs,
    fmt="o",
    color="blue",
    ecolor="blue",
    capsize=5,
    label=label_Mean,
)

# Dataset mean line
ax.axhline(y=dataset_mean, color="grey", linestyle="--", label=label_Dataset_mean)

# Customizing the plot
ax.set_ylabel(ylabel_value)
ax.set_xticklabels(activities, rotation=45, ha="right")
ax.legend()
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig('errorpoint_1.pdf', bbox_inches='tight')
