# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
categories = ["Wind Turbines", "Hydroelectric Dams", "Solar Panels", "Nuclear Plants", "Coal Plants"]
energy_output_means = [2400.5, 1800.2, 1500.6, 3200.3, 2100.7]  # Average energy output (MW)
errors = [150.0, 120.3, 100.8, 200.1, 180.9]  # Output variance (MW)
world_mean = [2000.4]  # Global average energy output (MW)
xlabel = "Average Energy Output (MW)"
label = "Global Average Energy Output"
plot_title = 'Average Energy Output by Energy Source'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    energy_output_means,
    categories,
    xerr=errors,
    fmt="*",
    color="#2a9d8f",
    ecolor="#1B998B",
    capsize=3,
    elinewidth=2,
    markeredgewidth=2,
    label="Region Mean",
)
plt.axvline(world_mean[0], color="#2a9d8f", linestyle="--", linewidth=3, label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc='upper right')
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_12.pdf", bbox_inches="tight")