# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data (example values, replace with actual data)
categories = [
    "Autonomous Vehicles",
    "Smart Cities",
    "Edge Computing",
    "5G Networks",
    "Wearable Technology",
    "Robotics",
]
unique_contributor_mean = [55, 65, 48, 30, 58, 52]  # Updated mean values for unique contributors
unique_disruptor_mean = [25, 22, 20, 23, 21, 19]  # Updated mean values for unique disruptors
unique_contributor_error = [6, 5, 4, 5.5, 5, 4.5]  # Updated error values for unique contributors
unique_disruptor_error = [3, 3.5, 2.5, 3.25, 3.5, 3.75]  # Updated error values for unique disruptors
legend_labels = ["Unique contributor count mean", "Unique disruptor count mean"]
y_axis_label = "Number of Unique Contributors"
average_disruptor_label = "Average Unique Disruptor Count"
plot_title = "Average Number of Unique Contributors and Disruptors in Emerging Tech Fields"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(12, 8)
)  # Adjust the size to match the original image's dimensions
ax.errorbar(
    categories,
    unique_contributor_mean,
    yerr=unique_contributor_error,
    fmt="^",
    color="navy",
    label=legend_labels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)
ax.errorbar(
    categories,
    unique_disruptor_mean,
    yerr=unique_disruptor_error,
    fmt="*",
    color="olivedrab",
    label=legend_labels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(y_axis_label)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(unique_disruptor_mean) / len(unique_disruptor_mean),
    color="grey",
    linestyle="--",
    linewidth=2,
    label=average_disruptor_label,
)
ax.legend()
ax.set_title(plot_title)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_14.pdf", bbox_inches="tight")