# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
environmental_issues = [
    "Melting Glaciers",
    "Sea Level Rise",
    "Coral Bleaching",
    "Ocean Acidification",
    "Permafrost Thawing",
]
mean_occurrence_rates = [0.27, 0.38, 0.32, 0.42, 0.22]  # Updated mean occurrence rates
upper_error_margins = [0.06, 0.05, 0.04, 0.05, 0.04]  # Updated upper error margins
lower_error_margins = [0.04, 0.03, 0.02, 0.03, 0.02]  # Updated lower error margins
legend_titles = ["Global Average", "Mean Occurrence Rate"]
annotation_text = "Environmental Change Occurrence"
ylabel = "Occurrence Rate (Fraction of Global Impact)"
title = "Environmental Change Impact Occurrence Rates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 8))

# Adjusting color scheme and marker style
ax.errorbar(
    environmental_issues,
    mean_occurrence_rates,
    yerr=[upper_error_margins, lower_error_margins],
    fmt="o",
    color="cyan",
    ecolor="cyan",
    capsize=5,
    markersize=8,
    markerfacecolor="purple",
    markeredgewidth=2,
)

# Adding a legend with both "Mean Occurrence" and "Dataset Mean"
global_average_rate = 0.29
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="^", color="cyan", ecolor="cyan", capsize=5, markersize=8,
    markerfacecolor="purple", markeredgewidth=2
)
global_average_line = ax.axhline(
    y=global_average_rate, color="teal", linestyle="--", linewidth=2
)
ax.legend(
    [global_average_line, mean_line],
    legend_titles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for global average rate and text annotation with a white background
ax.text(
    0.95,
    global_average_rate,
    annotation_text,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
    fontsize=10,
    weight='bold'
)

# Setting labels and title
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_16.pdf", bbox_inches="tight")