# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

np.random.seed(0)
labels = ["Ganten", "Nongfu Spring", "FIJI"]

x = np.linspace(0, 20, 6)
ganten_sales = np.random.uniform(60, 130, 6)
nongfu_sales = np.random.uniform(30, 80, 6)
fiji_sales = np.random.uniform(40, 90, 6)

ganten_error = [np.random.uniform(5, 10, 6), np.random.uniform(5, 10, 6)]
nongfu_error = [np.random.uniform(3, 6, 6), np.random.uniform(3, 6, 6)]
fiji_error = np.random.uniform(4, 8, 6)

title = "Sales Performance of Mineral Water Brands with Error Bars"
vertical_line_position = 10

titles = ["Ganten Sales Performance", "Nongfu Spring Sales Performance", "FIJI Sales Performance"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(6, 9), nrows=3, sharex=True)
ganten_colors = plt.get_cmap("YlOrRd")(np.linspace(0.2, 0.8, 6))
nongfu_colors = plt.get_cmap("Greens")(np.linspace(0.2, 0.8, 6))
fiji_color = "#33a02c"
# First subplot with symmetric vertical error bars
for i in range(len(x)):
    ax0.errorbar(
        x[i],
        ganten_sales[i],
        yerr=[[ganten_error[0][i]], [ganten_error[1][i]]],
        fmt="o",
        color=ganten_colors[i],
        capsize=4,
    )
    ax0.text(x[i] - 0.5, ganten_sales[i], f"{ganten_sales[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(titles[0])
ax0.axhline(y=75, linestyle="--", color="#FFA500")
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars
for i in range(len(x)):
    ax1.errorbar(
        x[i],
        nongfu_sales[i],
        xerr=[[nongfu_error[0][i]], [nongfu_error[1][i]]],
        fmt="o",
        color=nongfu_colors[i],
        capsize=4,
    )
    ax1.text(x[i] + 0.5, nongfu_sales[i] + 0.1, f"{nongfu_sales[i]:.2f}", fontsize=8, ha="left")
ax1.set_title(titles[1])
ax1.axvline(x=vertical_line_position, linestyle="--", color="#1E90FF")
ax1.xaxis.grid(True)
ax1.yaxis.grid(False)

# Third subplot with symmetric vertical error bars
ax2.errorbar(x, fiji_sales, yerr=fiji_error, fmt="*", color=fiji_color, capsize=4)
ax2.set_title(titles[2])
ax2.legend([labels[2]])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_19.pdf", bbox_inches="tight")