# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

x = np.arange(len(months))  # Months
skincare_sales = np.random.uniform(7, 2, len(months))
makeup_sales = np.random.uniform(7, 4, len(months))
fragrance_sales = np.random.uniform(3, 6.5, len(months))
error_skincare = [np.random.uniform(0.1, 0.5, len(months)), np.random.uniform(0.1, 0.5, len(months))]
error_makeup = [np.random.uniform(0.2, 1.0, len(months)), np.random.uniform(0.2, 1.0, len(months))]
error_fragrance = np.random.uniform(0.1, 0.8, len(months))
chart_title = "Monthly Sales of Beauty Products with Error Bars"
highlight_month = 6  # July

ylabel = ["Skincare Sales (Thousands)", "Makeup Sales (Thousands)", "Fragrance Sales (Thousands)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)
colors_skincare = plt.get_cmap("jet_r")(np.linspace(0.2, 0.8, len(months)))
colors_makeup = plt.get_cmap("tab20")(np.linspace(0.2, 0.8, len(months)))
color_fragrance = "gold"
# First subplot with symmetric vertical error bars (Skincare Sales)
for i in range(len(x)):
    ax0.errorbar(
        x[i],
        skincare_sales[i],
        yerr=[[error_skincare[0][i]], [error_skincare[1][i]]],
        fmt="o",
        color=colors_skincare[i],
        capsize=4,
    )
    ax0.text(x[i] - 0.2, skincare_sales[i] + 0.1, f"{skincare_sales[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(chart_title)
ax0.axhline(y=3.5, linestyle="--", color="#6b8e23")
ax0.set_ylabel(ylabel[0])
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars (Makeup Sales)
for i in range(len(x)):
    ax1.errorbar(
        x[i],
        makeup_sales[i],
        xerr=[[error_makeup[0][i]], [error_makeup[1][i]]],
        fmt="o",
        color=colors_makeup[i],
        markersize=8,
    )
    ax1.text(x[i] + 0.1, makeup_sales[i] + 0.1, f"{makeup_sales[i]:.2f}", fontsize=8, ha="left")
ax1.axvline(x=highlight_month, linestyle="--", color="#d45500")
ax1.set_ylabel(ylabel[1])
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with symmetric vertical error bars (Fragrance Sales)
ax2.errorbar(x, fragrance_sales, yerr=error_fragrance, fmt="*", color=color_fragrance, capsize=2)
for i in range(len(x)):
    ax2.text(x[i], fragrance_sales[i] + 0.1, f"{fragrance_sales[i]:.2f}", fontsize=8, ha="center")
ax2.set_ylabel(ylabel[2])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set shared x-axis labels
plt.xticks(x, months)
ax2.set_xlabel("Month")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_20.pdf", bbox_inches="tight")