
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
# Create a new graph representing a hypothetical legal network
G = nx.Graph()

# Add nodes representing different legal entities
# Add nodes representing different components in a cloud computing system
nodes = [("Headquarters", {"type": "Management"}),
         ("Regional Office", {"type": "Branch"}),
         ("Corporate Client", {"type": "Client"}),
         ("Retail Customer", {"type": "Client"}),
         ("Government Agency", {"type": "Regulator"})]
G.add_nodes_from(nodes)

# Add edges representing interactions
edges = [("Headquarters", "Regional Office"),
         ("Regional Office", "Corporate Client"),
         ("Regional Office", "Retail Customer"),
         ("Headquarters", "Government Agency"),
         ("Government Agency", "Corporate Client"),
         ("Government Agency", "Retail Customer")]
G.add_edges_from(edges)
title = "Legal Network of a Cloud Computing Company"
# Define positions for nodes explicitly
pos = {"Headquarters": (1, 2), "Regional Office": (1, 1), "Corporate Client": (0, 0), "Retail Customer": (2, 0), "Government Agency": (1, 3)}
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Node color mapping based on entity type
color_map = {"Management": "rosybrown", "Branch": "lemonchiffon", "Client": "gold", "Regulator": "aqua"}
# Draw nodes with colors based on their type
node_colors = [color_map[G.nodes[node]["type"]] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=4000, edgecolors='black')

# Draw edges with alpha for transparency and consistent width
nx.draw_networkx_edges(G, pos, edge_color="gray", alpha=0.7, width=2.5)

# Add labels to nodes
labels = {node: node for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="black")

# Create legend for node colors
import matplotlib.patches as mpatches
legend_elements = [mpatches.Patch(color=color, label=label) for label, color in color_map.items()]
plt.legend(handles=legend_elements, loc='upper left', frameon=False, fontsize=12)

# Title and axis settings
plt.title(title, fontsize=20, fontweight='bold')
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_11.pdf", bbox_inches="tight")

