import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
data = np.random.rand(10, 5) * 200 - 100  # Random data between -100 and 100 to reflect energy consumption or production in GWh
energy_sources = [
    "Coal",
    "Natural Gas",
    "Nuclear",
    "Hydro",
    "Wind",
    "Solar",
    "Geothermal",
    "Biomass",
    "Oil",
    "Other"
]
countries = ["USA", "China", "India", "Germany", "France"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(
    figsize=(6, 10)
)  # Adjusting figure size to match original image dimensions
cax = ax.matshow(data, cmap="coolwarm", vmin=-100, vmax=100)

# Set axis labels
ax.set_xticks(np.arange(len(countries)))
ax.set_yticks(np.arange(len(energy_sources)))
ax.set_xticklabels(countries)  # Removed rotation and alignment
ax.set_yticklabels(energy_sources)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=270, ha="center")

# Add colorbar
cbar = plt.colorbar(
    cax, aspect=10.5
)  # Adjusted shrink and aspect to match reference picture

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig('heatmap_14.pdf', bbox_inches='tight')
