import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
# Data in the heatmap
data = np.array(
    [
        [45, 80, 60, 50, 30, 25],
        [70, 55, 95, 45, 35, 20],
        [60, 90, 70, 40, 25, 30],
        [55, 65, 75, 60, 20, 25],
        [50, 75, 85, 55, 40, 35],
    ]
)

# Labels for rows and columns
row_labels = ["Bicycles", "Cars", "Buses", "Trains", "Airplanes"]
column_labels = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
title = "Transportation Usage Across Different Days"
xlabel = "Day of the Week"
ylabel = "Type of Transportation"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the matplotlib figure
f, ax = plt.subplots(figsize=(9, 6))

# Get the colors from the original colormap
original_cmap = plt.get_cmap("Paired_r")
colors = original_cmap(np.linspace(0, 1, original_cmap.N))

# Set the colormap with reverse order
cmap = mcolors.LinearSegmentedColormap.from_list("Paired_r", colors[::-1])

# Draw the heatmap with the reversed colormap
cax = ax.imshow(data, cmap=cmap)

# Set the title
ax.set_title(title, fontsize=18)

# Set labels for axes
ax.set_xlabel(xlabel, fontsize=18)
ax.set_ylabel(ylabel, fontsize=18)
ax.set_xticks(range(len(column_labels)))
ax.set_xticklabels(column_labels)
ax.set_yticks(range(len(row_labels)))
ax.set_yticklabels(row_labels)

# Increase font size of the tick labels
ax.tick_params(axis="both", which="major", labelsize=14)

# Rotate the row labels to horizontal and set the font size
ax.set_yticklabels(ax.get_yticklabels(), rotation=0, fontsize=14)

# Add the text annotations
for i in range(len(row_labels)):
    for j in range(len(column_labels)):
        text = ax.text(
            j, i, data[i, j], ha="center", va="center", color="w", fontsize=14
        )

# Create colorbar
cbar = f.colorbar(cax, ax=ax)
cbar.ax.tick_params(labelsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to fit the figure size
plt.tight_layout()
plt.savefig('heatmap_2.pdf', bbox_inches='tight')
