import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
# Creating dummy data based on the new domain 'education'
data_Techniques = pd.DataFrame(
    {
        "Homework": ["#1", "#2", "#3", "#4"],
        "Projects": ["#5", "#6", "#7", "#8"],
        "Exams": ["#9", "#10", "#11", "#12"],
    }
)

data_Performance = pd.DataFrame(
    {
        "Homework": ["#3", "#4", "#5", "#6"],
        "Projects": ["#7", "#8", "#9", "#10"],
        "Exams": ["#11", "#12", "#1", "#2"],
    }
)

# Creating a function to convert the string indices to numeric values for plotting
def convert_to_numeric(cell):
    return int(cell.replace("#", ""))


# Convert the dataframes
data_Techniques_numeric = data_Techniques.applymap(convert_to_numeric)
data_Performance_numeric = data_Performance.applymap(convert_to_numeric)

# Axes Limits and Labels
ax1_title = "Student1 Performance"
ax1_ylabel = "Rank"
ax2_title = "Student2 Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the heatmap using matplotlib with increased linewidths for separation
fig, (ax1, ax2) = plt.subplots(
    ncols=2, figsize=(6, 3), gridspec_kw={"width_ratios": [1, 1], "wspace": 0.1}
)

# Setting the color map to match the new domain
cmap_Techniques = plt.get_cmap("Oranges")
cmap_Performance = plt.get_cmap("Blues")

# Heatmap for Teaching Techniques with increased cell borders
im1 = ax1.imshow(data_Techniques_numeric, cmap=cmap_Techniques)
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_xticks(range(len(data_Techniques.columns)))
ax1.set_xticklabels(data_Techniques.columns, rotation=45)
ax1.set_yticks(range(len(data_Techniques.index)))
ax1.set_yticklabels(data_Techniques.index, rotation=0)

# Add annotations for Teaching Techniques
for i in range(len(data_Techniques.index)):
    for j in range(len(data_Techniques.columns)):
        ax1.text(j, i, data_Techniques.iloc[i, j], ha="center", va="center", color="black")

# Heatmap for Student Performance with increased cell borders
im2 = ax2.imshow(data_Performance_numeric, cmap=cmap_Performance)
ax2.set_title(ax2_title)
ax2.set_xticks(range(len(data_Performance.columns)))
ax2.set_xticklabels(data_Performance.columns, rotation=45)
ax2.set_yticks(range(len(data_Performance.index)))
ax2.set_yticklabels(data_Performance.index, rotation=0)

# Add annotations for Student Performance
for i in range(len(data_Performance.index)):
    for j in range(len(data_Performance.columns)):
        ax2.text(j, i, data_Performance.iloc[i, j], ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('heatmap_22.pdf', bbox_inches='tight')
