import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# New data
energy_sources = ["Solar", "Wind", "Hydro", "Geothermal", "Biomass", "Tidal", "Wave"]
countries = [
    "Country A",
    "Country B",
    "Country C",
    "Country D",
    "Country E",
    "Country F",
    "Country G",
]

generation = np.array(
    [
        [250, 320, 180, 430, 150, 500, 120],
        [480, 130, 560, 210, 320, 170, 160],
        [310, 220, 190, 600, 250, 620, 140],
        [170, 140, 110, 150, 420, 180, 190],
        [210, 290, 160, 380, 300, 770, 150],
        [260, 250, 140, 170, 180, 420, 650],
        [120, 290, 170, 240, 200, 340, 780],
    ]
)

title = "Renewable Energy Generation by Country (in GWh/year)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

im = ax.imshow(generation, cmap="OrRd")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(countries)), labels=countries)
ax.set_yticks(np.arange(len(energy_sources)), labels=energy_sources)

# Rotate the tick labels and set their alignment.
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(energy_sources)):
    for j in range(len(countries)):
        text = ax.text(j, i, generation[i, j], ha="center", va="center", color="black")

ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.show()
plt.savefig('heatmap_28.pdf', bbox_inches='tight')
