import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data for correlation coefficients in the energy sector
data = np.array(
    [
        [1.00, 0.78, 0.66, 0.55, 0.62, 0.70, 0.48, 0.57, 0.61],
        [0.78, 1.00, 0.72, 0.65, 0.59, 0.63, 0.55, 0.60, 0.68],
        [0.66, 0.72, 1.00, 0.73, 0.57, 0.61, 0.64, 0.58, 0.65],
        [0.55, 0.65, 0.73, 1.00, 0.66, 0.69, 0.71, 0.59, 0.62],
        [0.62, 0.59, 0.57, 0.66, 1.00, 0.79, 0.68, 0.72, 0.64],
        [0.70, 0.63, 0.61, 0.69, 0.79, 1.00, 0.76, 0.73, 0.71],
        [0.48, 0.55, 0.64, 0.71, 0.68, 0.76, 1.00, 0.74, 0.67],
        [0.57, 0.60, 0.58, 0.59, 0.72, 0.73, 0.74, 1.00, 0.70],
        [0.61, 0.68, 0.65, 0.62, 0.64, 0.71, 0.67, 0.70, 1.00],
    ]
)

labels = ["solar", "wind", "hydro", "nuclear", "coal", "gas", "biomass", "geothermal", "oil"]
title = "Correlation Coefficients of Energy Production Types"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Adjust the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create the heatmap
cax = ax.matshow(data, cmap="coolwarm")

# Adjust color bar width
cbar = fig.colorbar(
    cax,
    fraction=0.046,
    pad=0.04,
    ticks=[0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.80, 0.85, 0.90, 0.95, 1.00],
)
cbar.ax.set_yticklabels(
    ["0.50", "0.55", "0.60", "0.65", "0.70", "0.75", "0.80", "0.85", "0.90", "0.95", "1.00"]
)

# Set axis labels
ax.set_xticks(np.arange(len(labels)))
ax.set_yticks(np.arange(len(labels)))
# x label should be at the bottom
ax.xaxis.set_ticks_position("bottom")
ax.set_xticklabels(labels, rotation=45, ha="right")
ax.set_yticklabels(labels)

# Display the correlation values in the cells
for i in range(len(labels)):
    for j in range(len(labels)):
        ax.text(
            j,
            i,
            f"{data[i, j]:.2f}",
            va="center",
            ha="center",
            color="white" if data[i, j] < 0.65 else "black",
            fontsize=10,
        )

# Set title
ax.set_title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size and show the plot
fig.set_size_inches(10, 8)
fig.tight_layout()
plt.savefig('heatmap_7.pdf', bbox_inches='tight')
