import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Generate normally distributed data for annual sales (in millions)
data = np.array([76.46, 56.00, 64.68, 83.61, 78.01, 35.34, 64.25, 47.73, 48.45, 56.16, 52.16, 71.81, 61.42, 51.83, 56.66, 55.01, 72.41, 46.92, 54.70, 37.19, 
                 11.71, 59.80, 62.97, 38.87, 84.05, 28.18, 50.69, 47.19, 72.99, 72.04, 52.32, 55.67, 36.68, 20.29, 44.78, 52.35, 68.45, 68.04, 44.19, 45.47, 
                 34.27, 28.70, 24.41, 79.26, 42.36, 43.43, 31.21, 61.66, 25.79, 46.81, 36.57, 55.80, 42.34, 32.29, 49.58, 56.42, 50.99, 54.54, 40.49, 44.56, 
                 39.91, 44.61, 37.80, 24.11, 52.66, 43.97, 25.55, 56.94, 36.39, 50.78, 60.94, 51.93, 67.09, 31.48, 56.04, 39.73, 36.94, 41.32, 45.33, 50.84, 
                 32.52, 63.51, 56.98, 26.96, 72.32, 78.44, 67.68, 47.30, 33.94, 65.82, 43.95, 68.34, 53.12, 64.65, 55.35, 60.60, 50.16, 76.79, 51.90, 56.03])
# Axes Limits and Labels
title = "Histogram of Annual Sales"
xlabel_value = "Annual Sales (in millions)"
ylabel_value = "Number of Businesses"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(8, 6))

# Enable the grid
plt.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# Histogram of the data
n, bins, patches = plt.hist(data, bins=25, color="skyblue", edgecolor="blue", alpha=0.7)

# Highlight the median of the data
median = np.median(data)
plt.axvline(median, color="purple", linestyle="dashed", linewidth=2)

# Add text for the median
plt.text(median + 0.5, max(n) * 0.9, f"Median: ${median:.2f}M", color="purple")

# Title and labels relevant to annual sales data
plt.title(title)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig('hist_15.pdf', bbox_inches='tight')
